package com.hero.objects;

import org.jdom.Element;

import com.hero.objects.characteristics.Characteristic;
import com.hero.util.Constants;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */
public class CharAffectingObject extends GenericObject {

    protected boolean affectsPrimary;

    protected boolean affectsTotal;

    protected double bodyIncrease;

    protected int bodyIncreaseLevels;

    protected double comIncrease;

    protected int comIncreaseLevels;

    protected double conIncrease;

    protected int conIncreaseLevels;

    protected double custom10Increase;

    protected int custom10IncreaseLevels;

    protected double custom1Increase;

    protected int custom1IncreaseLevels;

    protected double custom2Increase;

    protected int custom2IncreaseLevels;

    protected double custom3Increase;

    protected int custom3IncreaseLevels;

    protected double custom4Increase;

    protected int custom4IncreaseLevels;

    protected double custom5Increase;

    protected int custom5IncreaseLevels;

    protected double custom6Increase;

    protected int custom6IncreaseLevels;

    protected double custom7Increase;

    protected int custom7IncreaseLevels;

    protected double custom8Increase;

    protected int custom8IncreaseLevels;

    protected double custom9Increase;

    protected int custom9IncreaseLevels;

    protected double dcvIncrease;

    protected int dcvIncreaseLevels;

    protected double defIncrease;

    protected int defIncreaseLevels;

    protected double dexIncrease;

    protected int dexIncreaseLevels;

    protected double ecvIncrease;

    protected int ecvIncreaseLevels;

    protected double edIncrease;

    protected int edIncreaseLevels;

    protected double egoIncrease;

    protected int egoIncreaseLevels;

    protected double endIncrease;

    protected int endIncreaseLevels;

    protected double heightIncrease;

    protected int heightIncreaseLevels;

    protected double intIncrease;

    protected int intIncreaseLevels;

    protected double kbIncrease;

    protected int kbIncreaseLevels;

    protected double leapingIncrease;

    protected int leapingIncreaseLevels;

    protected double massMultiplier;

    protected int massMultiplierLevels;

    protected double mdIncrease;

    protected int mdIncreaseLevels;

    protected double ocvIncrease;

    protected int ocvIncreaseLevels;

    protected double pdIncrease;

    protected int pdIncreaseLevels;

    protected double perIncrease;

    protected int perIncreaseLevels;

    protected double preIncrease;

    protected int preIncreaseLevels;

    protected double reachIncrease;

    protected int reachIncreaseLevels;

    protected double recIncrease;

    protected int recIncreaseLevels;

    protected double runningIncrease;

    protected int runningIncreaseLevels;

    protected double sizeIncrease;

    protected int sizeIncreaseLevels;

    protected double spdIncrease;

    protected int spdIncreaseLevels;

    protected double strIncrease;

    protected int strIncreaseLevels;

    protected double stunIncrease;

    protected int stunIncreaseLevels;

    protected double swimmingIncrease;

    protected int swimmingIncreaseLevels;

    protected double widthIncrease;

    protected int widthIncreaseLevels;
    
    protected double omcvIncrease;
    
    protected int omcvIncreaseLevels;
    
    protected double dmcvIncrease;
    
    protected int dmcvIncreaseLevels;

    public CharAffectingObject(Element root) {
        super(root);
    }

    public CharAffectingObject(Element root, String xmlID) {
        super(root, xmlID);
    }

    /**
     * returns true if the parent object can affect the passed in figured
     * characteristic.
     * 
     * @param parent
     * @param figuredType
     * @return
     */
    public static boolean checkFigured(GenericObject parent, int figuredType) {
        if (figuredType == Constants.LEAPING
                || figuredType == Constants.RUNNING
                || figuredType == Constants.SWIMMING) {
            if (parent instanceof Characteristic) {
                Characteristic ch = (Characteristic) parent;
                if (ch.getPrimaryValue() < 0 && ch.getSecondaryValue() < 0) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (GenericObject.findObjectByID(parent.getAssignedModifiers(),
                "NOFIGURED") != null
                || parent.getParentList() != null && GenericObject.findObjectByID(parent
                        .getParentList().getAssignedModifiers(), "NOFIGURED") != null) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Returns true if the object affects/increases any of the Characteristics,
     * false otherwise.
     * 
     * @return
     */
    public boolean affectsCharacteristics() {
        if (getStrIncrease() != 0) {
            return true;
        }
        if (getDexIncrease() != 0) {
            return true;
        }
        if (getConIncrease() != 0) {
            return true;
        }
        if (getBodyIncrease() != 0) {
            return true;
        }
        if (getIntIncrease() != 0) {
            return true;
        }
        if (getEgoIncrease() != 0) {
            return true;
        }
        if (getPreIncrease() != 0) {
            return true;
        }
        if (getComIncrease() != 0) {
            return true;
        }
        if (getPdIncrease() != 0) {
            return true;
        }
        if (getEdIncrease() != 0) {
            return true;
        }
        if (getSpdIncrease() != 0) {
            return true;
        }
        if (getRecIncrease() != 0) {
            return true;
        }
        if (getEndIncrease() != 0) {
            return true;
        }
        if (getStunIncrease() != 0) {
            return true;
        }
        if (getDefIncrease() != 0) {
            return true;
        }
        if (getSizeIncrease() != 0) {
            return true;
        }
        if (getRunningIncrease() != 0) {
            return true;
        }
        if (getSwimmingIncrease() != 0) {
            return true;
        }
        if (getLeapingIncrease() != 0) {
            return true;
        }
        if (getCustom1Increase() != 0) {
            return true;
        }
        if (getCustom2Increase() != 0) {
            return true;
        }
        if (getCustom3Increase() != 0) {
            return true;
        }
        if (getCustom4Increase() != 0) {
            return true;
        }
        if (getCustom5Increase() != 0) {
            return true;
        }
        if (getCustom6Increase() != 0) {
            return true;
        }
        if (getCustom7Increase() != 0) {
            return true;
        }
        if (getCustom8Increase() != 0) {
            return true;
        }
        if (getCustom9Increase() != 0) {
            return true;
        }
        if (getCustom10Increase() != 0) {
            return true;
        } if (getOmcvIncrease() != 0) {  
        	return true;
        } if (getDmcvIncrease() != 0) {  
        	return true;
        }  else {
            return false;
        }
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof GenericObject) {
            GenericObject go = (GenericObject) obj;
            return getPosition() - go.getPosition();
        } else {
            return toString().compareTo(obj.toString());
        }
    }

    public boolean getAffectPrimary() {
        return affectsPrimary;
    }

    /**
     * Whether the object adds into the total value.
     * 
     * @return
     */
    public boolean getAffectTotal() {
        if (affectsPrimary) {
            affectsTotal = true;
        }
        return affectsTotal;
    }

    public double getBodyIncrease() {
        // if (!checkFigured(this)) return 0;
        return bodyIncrease;
    }

    public int getBodyIncreaseLevels() {
        return bodyIncreaseLevels;
    }

    public double getComIncrease() {
        // if (!checkFigured(this)) return 0;
        return comIncrease;
    }

    public int getComIncreaseLevels() {
        return comIncreaseLevels;
    }

    public double getConIncrease() {
        // if (!checkFigured(this)) return 0;
        return conIncrease;
    }

    public int getConIncreaseLevels() {
        return conIncreaseLevels;
    }

    public double getCustom10Increase() {
        return custom10Increase;
    }

    public int getCustom10IncreaseLevels() {
        return custom10IncreaseLevels;
    }

    public double getCustom1Increase() {
        return custom1Increase;
    }

    public int getCustom1IncreaseLevels() {
        return custom1IncreaseLevels;
    }

    public double getCustom2Increase() {
        return custom2Increase;
    }

    public int getCustom2IncreaseLevels() {
        return custom2IncreaseLevels;
    }

    public double getCustom3Increase() {
        return custom3Increase;
    }

    public int getCustom3IncreaseLevels() {
        return custom3IncreaseLevels;
    }

    public double getCustom4Increase() {
        return custom4Increase;
    }

    public int getCustom4IncreaseLevels() {
        return custom4IncreaseLevels;
    }

    public double getCustom5Increase() {
        return custom5Increase;
    }

    public int getCustom5IncreaseLevels() {
        return custom5IncreaseLevels;
    }

    public double getCustom6Increase() {
        return custom6Increase;
    }

    public int getCustom6IncreaseLevels() {
        return custom6IncreaseLevels;
    }

    public double getCustom7Increase() {
        return custom7Increase;
    }

    public int getCustom7IncreaseLevels() {
        return custom7IncreaseLevels;
    }

    public double getCustom8Increase() {
        return custom8Increase;
    }

    public int getCustom8IncreaseLevels() {
        return custom8IncreaseLevels;
    }

    public double getCustom9Increase() {
        return custom9Increase;
    }

    public int getCustom9IncreaseLevels() {
        return custom9IncreaseLevels;
    }

    public double getDcvIncrease() {
        return dcvIncrease;
    }

    public int getDcvIncreaseLevels() {
        return dcvIncreaseLevels;
    }

    public double getDefIncrease() {
        // if (!checkFigured(this)) return 0;
        return defIncrease;
    }

    public int getDefIncreaseLevels() {
        return defIncreaseLevels;
    }

    public double getDexIncrease() {
        // if (!checkFigured(this)) return 0;
        return dexIncrease;
    }

    public int getDexIncreaseLevels() {
        return dexIncreaseLevels;
    }

    public String getDisplayNotes() {
        return "";
    }

    public double getEcvIncrease() {
        return ecvIncrease;
    }

    public int getEcvIncreaseLevels() {
        return ecvIncreaseLevels;
    }

    public double getEdIncrease() {
        // if (!checkFigured(this)) return 0;
        return edIncrease;
    }

    public int getEdIncreaseLevels() {
        return edIncreaseLevels;
    }

    public double getEgoIncrease() {
        // if (!checkFigured(this)) return 0;
        return egoIncrease;
    }

    public int getEgoIncreaseLevels() {
        return egoIncreaseLevels;
    }

    public double getEndIncrease() {
        // if (!checkFigured(this)) return 0;
        return endIncrease;
    }

    public int getEndIncreaseLevels() {
        return endIncreaseLevels;
    }

    public double getHeightIncrease() {
        return heightIncrease;
    }

    public int getHeightIncreaseLevels() {
        return heightIncreaseLevels;
    }

    /**
     * Finds the increase value for the specified Characteristic type.
     * 
     * @param type
     * @return
     */
    public double getIncrease(int type) {
        switch (type) {
            case Constants.BODY:
                return getBodyIncrease();
            case Constants.COM:
                return getComIncrease();
            case Constants.CON:
                return getConIncrease();
            case Constants.DEF:
                return getDefIncrease();
            case Constants.DEX:
                return getDexIncrease();
            case Constants.ED:
                return getEdIncrease();
            case Constants.EGO:
                return getEgoIncrease();
            case Constants.END:
                return getEndIncrease();
            case Constants.INT:
                return getIntIncrease();
            case Constants.PD:
                return getPdIncrease();
            case Constants.PRE:
                return getPreIncrease();
            case Constants.REC:
                return getRecIncrease();
            case Constants.SIZE:
                return getSizeIncrease();
            case Constants.SPD:
                return getSpdIncrease();
            case Constants.STR:
                return getStrIncrease();
            case Constants.STUN:
                return getStunIncrease();
            case Constants.LEAPING:
                return getLeapingIncrease();
            case Constants.RUNNING:
                return getRunningIncrease();
            case Constants.SWIMMING:
                return getSwimmingIncrease();
            case Constants.CUSTOM1:
                return getCustom1Increase();
            case Constants.CUSTOM2:
                return getCustom2Increase();
            case Constants.CUSTOM3:
                return getCustom3Increase();
            case Constants.CUSTOM4:
                return getCustom4Increase();
            case Constants.CUSTOM5:
                return getCustom5Increase();
            case Constants.CUSTOM6:
                return getCustom6Increase();
            case Constants.CUSTOM7:
                return getCustom7Increase();
            case Constants.CUSTOM8:
                return getCustom8Increase();
            case Constants.CUSTOM9:
                return getCustom9Increase();
            case Constants.CUSTOM10:
                return getCustom10Increase();
            default:
                return 0;
        }
    }

    /**
     * Finds the number of levels for an increase for the given
     * Characteristic-type.
     * 
     * @param type
     * @return
     */
    public int getIncreaseLevels(int type) {
        switch (type) {
            case Constants.BODY:
                return getBodyIncreaseLevels();
            case Constants.COM:
                return getComIncreaseLevels();
            case Constants.CON:
                return getConIncreaseLevels();
            case Constants.DEF:
                return getDefIncreaseLevels();
            case Constants.DEX:
                return getDexIncreaseLevels();
            case Constants.ED:
                return getEdIncreaseLevels();
            case Constants.EGO:
                return getEgoIncreaseLevels();
            case Constants.END:
                return getEndIncreaseLevels();
            case Constants.INT:
                return getIntIncreaseLevels();
            case Constants.PD:
                return getPdIncreaseLevels();
            case Constants.PRE:
                return getPreIncreaseLevels();
            case Constants.REC:
                return getRecIncreaseLevels();
            case Constants.SIZE:
                return getSizeIncreaseLevels();
            case Constants.SPD:
                return getSpdIncreaseLevels();
            case Constants.STR:
                return getStrIncreaseLevels();
            case Constants.STUN:
                return getStunIncreaseLevels();
            case Constants.LEAPING:
                return getLeapingIncreaseLevels();
            case Constants.SWIMMING:
                return getSwimmingIncreaseLevels();
            case Constants.RUNNING:
                return getRunningIncreaseLevels();
            case Constants.CUSTOM1:
                return getCustom1IncreaseLevels();
            case Constants.CUSTOM2:
                return getCustom2IncreaseLevels();
            case Constants.CUSTOM3:
                return getCustom3IncreaseLevels();
            case Constants.CUSTOM4:
                return getCustom4IncreaseLevels();
            case Constants.CUSTOM5:
                return getCustom5IncreaseLevels();
            case Constants.CUSTOM6:
                return getCustom6IncreaseLevels();
            case Constants.CUSTOM7:
                return getCustom7IncreaseLevels();
            case Constants.CUSTOM8:
                return getCustom8IncreaseLevels();
            case Constants.CUSTOM9:
                return getCustom9IncreaseLevels();
            case Constants.CUSTOM10:
                return getCustom10IncreaseLevels();
            default:
                return 0;
        }
    }

    /**
     * Find the increase value for the specified Characteristic-type.
     * 
     * @param type
     * @param primary
     *            Specifies whether we are interested in a primary value or not.
     *            Abilities which add to a secondary value (or don't add) should
     *            not be included in a primary calculation.
     * @return
     */
    public double getIncreaseValue(int type, boolean primary) {
        if (getIncreaseLevels(type) == 0) {
            return 0;
        }
        if (primary && (!getAffectPrimary() || !getAffectTotal())) {
            return 0;
        } else if (!primary && (getAffectPrimary() || !getAffectTotal())) {
            return 0;
        } else if (!getAffectTotal()) {
            return 0;
        }
        double ret = getLevels() * getIncrease(type) / getIncreaseLevels(type);
        return ret;
    }

    public double getIntIncrease() {
        // if (!checkFigured(this)) return 0;
        return intIncrease;
    }

    public int getIntIncreaseLevels() {
        return intIncreaseLevels;
    }

    public double getKbIncrease() {
        // if (!checkFigured(this)) return 0;
        return kbIncrease;
    }

    public int getKbIncreaseLevels() {
        return kbIncreaseLevels;
    }

    public double getLeapingIncrease() {
        return leapingIncrease;
    }

    public int getLeapingIncreaseLevels() {
        return leapingIncreaseLevels;
    }

    @Override
    public int getLevels() {
        return levels;
    }

    public double getMassMultiplier() {
        // if (!checkFigured(this)) return 0;
        return massMultiplier;
    }

    public int getMassMultiplierLevels() {
        return massMultiplierLevels;
    }

    public double getMDIncrease() {
        return mdIncrease;
    }

    public int getMDIncreaseLevels() {
        return mdIncreaseLevels;
    }

    public double getOcvIncrease() {
        return ocvIncrease;
    }

    public int getOcvIncreaseLevels() {
        return ocvIncreaseLevels;
    }
    
    public double getOmcvIncrease() {
        return omcvIncrease;
    }

    public int getOmcvIncreaseLevels() {
        return omcvIncreaseLevels;
    }
    
    public double getDmcvIncrease() {
        return dmcvIncrease;
    }

    public int getDmcvIncreaseLevels() {
        return dmcvIncreaseLevels;
    }

    public double getPdIncrease() {
        // if (!checkFigured(this)) return 0;
        return pdIncrease;
    }

    public int getPdIncreaseLevels() {
        return pdIncreaseLevels;
    }

    public double getPerIncrease() {
        return perIncrease;
    }

    public int getPerIncreaseLevels() {
        return perIncreaseLevels;
    }

    public double getPreIncrease() {
        // if (!checkFigured(this)) return 0;
        return preIncrease;
    }

    public int getPreIncreaseLevels() {
        return preIncreaseLevels;
    }

    public double getReachIncrease() {
        return reachIncrease;
    }

    public int getReachIncreaseLevels() {
        return reachIncreaseLevels;
    }

    public double getRecIncrease() {
        // if (!checkFigured(this)) return 0;
        return recIncrease;
    }

    public int getRecIncreaseLevels() {
        return recIncreaseLevels;
    }

    public double getRunningIncrease() {
        return runningIncrease;
    }

    public int getRunningIncreaseLevels() {
        return runningIncreaseLevels;
    }

    public double getSizeIncrease() {
        // if (!checkFigured(this)) return 0;
        return sizeIncrease;
    }

    public int getSizeIncreaseLevels() {
        return sizeIncreaseLevels;
    }

    public double getSpdIncrease() {
        // if (!checkFigured(this)) return 0;
        return spdIncrease;
    }

    public int getSpdIncreaseLevels() {
        return spdIncreaseLevels;
    }

    public double getStrIncrease() {
        // if (!checkFigured(this)) return 0;
        return strIncrease;
    }

    public int getStrIncreaseLevels() {
        return strIncreaseLevels;
    }

    public double getStunIncrease() {
        // if (!checkFigured(this)) return 0;
        return stunIncrease;
    }

    public int getStunIncreaseLevels() {
        return stunIncreaseLevels;
    }

    public double getSwimmingIncrease() {
        return swimmingIncrease;
    }

    public int getSwimmingIncreaseLevels() {
        return swimmingIncreaseLevels;
    }

    /**
     * The type of the object (default is GENERAL)
     * 
     * @see com.hero.util.Constants
     * @return
     */
    public int getType() {
        return Constants.GENERAL;
    }

    public double getWidthIncrease() {
        return widthIncrease;
    }

    public int getWidthIncreaseLevels() {
        return widthIncreaseLevels;
    }

    @Override
    protected void init(Element element) {
        baseCost = 0;
        affectsPrimary = true;
        affectsTotal = true;

        strIncrease = 0;
        strIncreaseLevels = 1;
        dexIncrease = 0;
        dexIncreaseLevels = 1;
        conIncrease = 0;
        conIncreaseLevels = 1;
        bodyIncrease = 0;
        bodyIncreaseLevels = 1;
        intIncrease = 0;
        intIncreaseLevels = 1;
        egoIncrease = 0;
        egoIncreaseLevels = 1;
        preIncrease = 0;
        preIncreaseLevels = 1;
        comIncrease = 0;
        comIncreaseLevels = 1;
        pdIncrease = 0;
        pdIncreaseLevels = 1;
        edIncrease = 0;
        edIncreaseLevels = 1;
        spdIncrease = 0;
        spdIncreaseLevels = 1;
        recIncrease = 0;
        recIncreaseLevels = 1;
        endIncrease = 0;
        endIncreaseLevels = 1;
        stunIncrease = 0;
        stunIncreaseLevels = 1;
        kbIncrease = 0;
        kbIncreaseLevels = 1;
        massMultiplier = 0;
        massMultiplierLevels = 1;
        reachIncrease = 0;
        reachIncreaseLevels = 1;
        heightIncrease = 0;
        heightIncreaseLevels = 1;
        widthIncrease = 0;
        widthIncreaseLevels = 1;
        dcvIncrease = 0;
        dcvIncreaseLevels = 1;
        ocvIncrease = 0;
        ocvIncreaseLevels = 1;
        omcvIncrease = 0;
        omcvIncreaseLevels = 1;
        dmcvIncrease = 0;
        dmcvIncreaseLevels = 1;
        perIncrease = 0;
        perIncreaseLevels = 1;
        ecvIncrease = 0;
        ecvIncreaseLevels = 1;
        defIncrease = 0;
        defIncreaseLevels = 1;
        sizeIncrease = 0;
        sizeIncreaseLevels = 1;
        leapingIncrease = 0;
        leapingIncreaseLevels = 1;
        runningIncrease = 0;
        runningIncreaseLevels = 1;
        swimmingIncrease = 0;
        swimmingIncreaseLevels = 1;
        custom1Increase = 0;
        custom1IncreaseLevels = 1;
        custom2Increase = 0;
        custom2IncreaseLevels = 1;
        custom3Increase = 0;
        custom3IncreaseLevels = 1;
        custom4Increase = 0;
        custom4IncreaseLevels = 1;
        custom5Increase = 0;
        custom5IncreaseLevels = 1;
        custom6Increase = 0;
        custom6IncreaseLevels = 1;
        custom7Increase = 0;
        custom7IncreaseLevels = 1;
        custom8Increase = 0;
        custom8IncreaseLevels = 1;
        custom9Increase = 0;
        custom9IncreaseLevels = 1;
        custom10Increase = 0;
        custom10IncreaseLevels = 1;
        mdIncrease = 0;
        mdIncreaseLevels = 1;

        super.init(element);


        String check;

        check = XMLUtility.getValue(element, "STRINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                strIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "STRINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                strIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DEXINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dexIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DEXINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dexIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CONINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                conIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CONINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                conIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "BODYINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                bodyIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "BODYINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                bodyIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "INTINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                intIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "INTINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                intIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "EGOINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                egoIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "EGOINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                egoIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PREINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                preIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PREINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                preIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "COMINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                comIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "COMINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                comIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PDINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                pdIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PDINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                pdIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "EDINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                edIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "EDINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                edIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SPDINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                spdIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SPDINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                spdIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "RECINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                recIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "RECINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                recIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "ENDINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                endIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "ENDINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                endIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "STUNINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                stunIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "STUNINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                stunIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "KBINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                kbIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "KBINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                kbIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "MASSMULTIPLIER");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                massMultiplier = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "MASSMULTIPLIERLEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                massMultiplierLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "REACHINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                reachIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "REACHINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                reachIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "HEIGHTINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                heightIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "HEIGHTINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                heightIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "WIDTHINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                widthIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "WIDTHINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                widthIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DCVINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dcvIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DCVINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dcvIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "OCVINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                ocvIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "OCVINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                ocvIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "OMCVINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                omcvIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "OMCVINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                omcvIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DMCVINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dmcvIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DMCVINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                dmcvIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PERINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                perIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "PERINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                perIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "ECVINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                ecvIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "ECVINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                ecvIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DEFINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                defIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "DEFINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                defIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SIZEINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                sizeIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SIZEINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                sizeIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "LEAPINGINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                leapingIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "LEAPINGINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                leapingIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "RUNNINGINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                runningIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "RUNNINGINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                runningIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SWIMMINGINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                swimmingIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "SWIMMINGINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                swimmingIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM1INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom1Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM1INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom1IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM2INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom2Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM2INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom2IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM3INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom3Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM3INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom3IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM4INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom4Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM4INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom4IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM5INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom5Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM5INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom5IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM6INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom6Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM6INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom6IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM7INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom7Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM7INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom7IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM8INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom8Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM8INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom8IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM9INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom9Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM9INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom9IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM10INCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom10Increase = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "CUSTOM10INCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                custom10IncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "MDINCREASE");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                mdIncrease = Double.parseDouble(check);
            } catch (NumberFormatException ex) {
            }
        }
        check = XMLUtility.getValue(element, "MDINCREASELEVELS");
        if (check != null && check.trim().toUpperCase().length() > 0) {
            try {
                mdIncreaseLevels = Integer.parseInt(check);
            } catch (NumberFormatException ex) {
            }
        }
    }

    public void setAffectPrimary(boolean val) {
        affectsPrimary = val;
    }

    /**
     * Sets whether the object adds into the total value.
     * 
     * @param val
     */
    public void setAffectTotal(boolean val) {
        affectsTotal = val;
    }
}